/*
 * ll_list.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include <stdio.h>
#include "ll_list.h"

ll_list *ll_create() {
	ll_list *list = malloc(sizeof(ll_list));
	if (list == NULL) {
		return NULL;
	}
	memset(list, 0, sizeof(ll_list));
	list->_head = malloc(sizeof(ll_head));
	if (list->_head == NULL) {
		free(list);
		return NULL;
	}
	list->_head->_first = list->_head->_last = list;
	return list;
}

void ll_release(ll_list **list) {
	ll_list *tlist = *list;
	tlist = tlist->_head->_last;
	while(tlist->_prev != NULL) {
		if (tlist->_data != NULL) {
			free(tlist->_data);
		}
		tlist = tlist->_prev;
		free(tlist->_next);
	}
	if (tlist->_data != NULL) {
		free(tlist->_data);
	}
	free(tlist->_head);
	free(tlist);
	*list = NULL;
}

void ll_clear(ll_list *list) {
	ll_list *tlist = list;
	tlist = tlist->_head->_last;
	while(tlist->_prev != NULL) {
		if (tlist->_data != NULL) {
			free(tlist->_data);
		}
		tlist = tlist->_prev;
		free(tlist->_next);
	}
	tlist->_next = NULL;
	if (tlist->_data != NULL) {
		free(tlist->_data);
		tlist->_data = NULL;
	}
	tlist->_head->_count = 0;
	tlist->_head->_first = tlist->_head->_last = tlist;
}

ll_list *ll_add(ll_list *list, void *data, size_t size) {
	ll_list *tlist = NULL;
	void **tdata;

	if (list->_data == NULL) {
		tdata = &list->_data;
	} else {
		if ((tlist = malloc(sizeof(ll_list))) == NULL) {
			return NULL;
		}
		memset(tlist, 0, sizeof(ll_list));
		tlist->_head = list->_head;
		tdata = &tlist->_data;
	}
	if ((*tdata = malloc(size)) == NULL) {
		if (tlist != NULL) {
			free(tlist);
		}
		return NULL;
	}
	memcpy(*tdata, data, size);
	if (tlist == NULL) {
		tlist = list;
	} else {
		if (list->_next != NULL) {
			list = list->_next;
		}
		tlist->_next = list->_next;
		list->_next = tlist;
		tlist->_prev = list;
		if (list->_head->_last == list) {
			list->_head->_last = tlist;
		}
	}
	tlist->_head->_count++;
	return tlist;
}

ll_list *ll_delete(ll_list *list) {
	ll_list *tlist;

	if (list->_data == NULL) {
		return NULL;
	}
	free(list->_data);
	list->_data = NULL;
	tlist = (list->_next == NULL? list->_prev: list->_next);
	if (tlist == NULL) {
		tlist = list;
	} else {
		if (list->_next != NULL) {
			list->_next->_prev = list->_prev;
		}
		if (list->_prev != NULL) {
			list->_prev->_next = list->_next;
		}
		if (list->_head->_last == list) {
			list->_head->_last = tlist;
		}
		if (list->_head->_first == list) {
			list->_head->_first = tlist;
		}
		free(list);
	}
	tlist->_head->_count--;
	return tlist;
}

ll_list *ll_replace(ll_list *list, void *data, size_t size) {
	if (list->_data == NULL) {
		return NULL;
	}
	memcpy(list->_data, data, size);
	return list;
}
