/*
 * ll_list.h
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#ifndef _LL_LIST_H_
#define _LL_LIST_H_

#include <stdlib.h>
#include <string.h>

#define ll_count(list)	(list)->_head->_count
#define ll_first(list)	(list)->_head->_first
#define ll_last(list)	(list)->_head->_last
#define ll_next(list)	(list)->_next
#define ll_prev(list)	(list)->_prev
#define ll_get(list)		(list)->_data

typedef struct _ll_head {
	int _count;
	struct _ll_list *_first;
	struct _ll_list *_last;
} ll_head;

typedef struct _ll_list {
	void *_data;
	struct _ll_list *_prev;
	struct _ll_list *_next;
	ll_head *_head;
} ll_list;

ll_list *ll_create();
void ll_release(ll_list **list);
void ll_clear(ll_list *list);
ll_list *ll_add(ll_list *list, void *data, size_t size);
ll_list *ll_delete(ll_list *list);
ll_list *ll_replace(ll_list *list, void *data, size_t size);

#endif /* #ifndef _LL_LIST_H_ */
