/*
 * __jdcs_call.h
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */
#ifndef __JDCS_CALL_H_
#define __JDCS_CALL_H_

#include "_jdcs.h"

#define SET_AND_RETURN_STS(jenv, jobj, info, sts) \
	((*jenv)->SetIntField(jenv, jobj, info->stsID, (jint)(sts)), sts)

#define GET_DCS_INFO_BY_OBJECT(jenv, jobj, info) \
	( \
	info = (_JDcsInfo *)(*jenv)->GetLongField(jenv, jobj, \
			(*jenv)->GetFieldID(jenv, (*jenv)->GetObjectClass(jenv, jobj), _HDCS_INFO_NAME, "J")) \
	)

#define CALL_DCS_INFO_BY_OBJECT(func_name, dcs, ...) \
		func_name((dcs), ##__VA_ARGS__)

#ifdef _JDCS_CALL_BOM_H_
#define _DCSM_CALL_SCSTO_DCS_BOM(func_name, dcs, dbuf, dsize, eptr, sbuf, ssize, isBom) \
		(func_name)(dcs, &dbuf, &dsize, &eptr, sbuf, ssize, isBom)
#else
#define _DCSM_CALL_SCSTO_DCS_BOM(func_name, dcs, dbuf, dsize, eptr, sbuf, ssize, isBom) \
		_DCSM_CALL_SCSTO_DCS(func_name, dcs, dbuf, dsize, eptr, sbuf, ssize)
#define _DCSM_CALL_SCSTO_DCS(func_name, dcs, dbuf, dsize, eptr, sbuf, ssize) \
		(func_name)(dcs, &dbuf, &dsize, &eptr, sbuf, ssize)
#endif

#define _DCSM_SCSTO_DCS_BOM(func_name, jenv, jobj, jdbuf, jeoffset, jsbuf, jssize, isBom) { \
	int sts; \
	size_t ssize, dsize; \
	char *sptr, *dbuf, *eptr; \
	jboolean isCopy; \
	jbyteArray jbuf; \
	_JDcsInfo *info; \
	GET_DCS_INFO_BY_OBJECT(jenv, jobj, info); \
	ssize = min(jssize, (*jenv)->GetArrayLength(jenv, jsbuf)); \
	sptr = (*jenv)->GetByteArrayElements(jenv, jsbuf, &isCopy); \
	sts = _DCSM_CALL_SCSTO_DCS_BOM(func_name, info->dcs, dbuf, dsize, eptr, sptr, ssize, isBom); \
	(*jenv)->ReleaseByteArrayElements(jenv, jsbuf, sptr,0); \
	jbuf = (*jenv)->NewByteArray(jenv, dsize); \
	(*jenv)->SetObjectArrayElement(jenv, jdbuf, 0, jbuf); \
	if (sts == DCS_SUCCESS || sts == DCS_ECHAR || sts == DCS_EUEXPEOD) { \
		/* バイト配列を生成 */ \
		(*jenv)->SetByteArrayRegion(jenv, jbuf, 0, dsize, (void *)dbuf); \
		free(dbuf); \
		if (sts != DCS_SUCCESS) { \
			if (jeoffset != NULL) { \
				int aint[1]; \
				aint[0] = (eptr - sptr); \
				(*jenv)->SetIntArrayRegion(jenv, jeoffset, 0, 1, (void *)aint); \
			} \
		} \
	} \
	return SET_AND_RETURN_STS(jenv, jobj, info, sts); }

#define _DCSM_SCSTO_DCS(func_name, jenv, jobj, jdbuf, jeoffset, jsbuf, jssize) \
	_DCSM_SCSTO_DCS_BOM(func_name, jenv, jobj, jdbuf, jeoffset, jsbuf, jssize, false)

#endif
