/*
 * _jdcs.h
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#ifndef _JDCS_H_
#define _JDCS_H_

#include <stdlib.h>
#include <limits.h>

#include "rabbit_dcs_Dcs.h"
#include "_dcs.h"
#include "jdcs.h"
#include "__jdcs_call.h"

#define _HDCS_INFO_NAME		"_hdcsInfo"
#define _VERSION_NAME		"nversion"

#define dcs_is_euc_long		is_euc_long
#define dcs_is_jis_short	is_jis_short
#define dcs_is_sjis_short	is_sjis_short
#define dcs_is_unibe_short	is_unibe_short
#define dcs_is_unile_short	is_unile_short

#ifndef min
#define min(a, b)               ((a)<(b)?(a):(b))
#define max(a, b)               ((a)>(b)?(a):(b))
#endif /* #ifndef min */

#define _JDCS_KEY_BUF_MIN       256

#define GLOBAL_REF   1
#define _GLOBAL_REF_SET    0
#define _GLOBAL_REF_TRACE  0
#define _JDCS_REF_MAX 100

typedef struct _jdcs_info {
  JNIEnv *env;
  jclass cls;
  jobject obj;
  Dcs *dcs;
  jfieldID stsID;
  jfieldID versionID;
} _JDcsInfo;

typedef struct _jni_judged_stream_info {
	JNIEnv *jenv;
	jobject jobj;
	_JDcsInfo *info;
	jobject jistream;
	jmethodID mid_buf;
	jmethodID mid_char;
	jbyteArray jbuf;
} JniJudgedStreamInfo;

#define OBSERVER_SIGNATURE		"(ILjava/lang/Object;)I"
#define WRITER_SIGNATURE		"([BILjava/lang/Object;)I"

typedef struct _jni_convert_info {
	JNIEnv *jenv;
	jobject jobj;
	_JDcsInfo *info;
	jobject jistream;
	jmethodID mid_buf;
	jmethodID mid_char;
	jbyteArray jbuf;
// ここまで JniJudgedStreamInfo と共通
	jmethodID mid_ob;
	jmethodID mid_wr;
	jobject jobserver;
	jobject jwriter;
} JniConvertInfo;

#endif /* #ifndef _JDCS_H_ */
