/*
 * jdcs.h
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#ifndef JDCS_H_
#define JDCS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "dcs.h"

#define JDCS_VERSION            ((float)3.00)

/* STATUS NUMBERS */
#define JDCS_SUCCESS		0 /* 処理成功 */
#define JDCS_EOF			-1 /* 入力ファイルの終わり */
#define JDCS_ENOTEXISTS		-2 /* ファイルは存在せず */
#define JDCS_ENOTFILE		-3 /* 通常ファイルではない */
#define JDCS_EALLOC			-4 /* メモリー・アロケート・エラー */
#define JDCS_EROPEN			-5 /* 入力ファイル・オープン・エラー */
#define JDCS_EWOPEN			-6 /* 出力ファイル・オープン・エラー */
#define JDCS_EREAD			-7 /* 入力エラー */
#define JDCS_EWRITE			-8 /* 出力エラー */

#define JDCS_EIOMODE			-10 /* 入出力モード誤り */
#define JDCS_EIOFDRANGE		-11 /* ファイル記述子範囲誤り */
#define JDCS_EIONOTOPEN		-12 /* 未オープン・ファイルへのアクセス */
#define JDCS_EIOMAX			-13 /* 上限を超えたファイル・オープン */

#define JDCS_ECTYPE			-20 /* コード・タイプ誤り */
#define JDCS_EBOM			-21 /* BOM 不正（未使用） */
#define JDCS_EUEXPEOD		-22 /* 予期せぬデータの終わり */
#define JDCS_ECHAR			-23 /* コード値エラー */
#define JDCS_ELTYPE			-24 /* 改行コード・タイプ誤り */

#define JDCS_ECANOBS		-30 /* 監視者による取り消し */

#define JDCS_EJNI_ARRAY_LENGTH		-50
#define JDCS_EJNI_FIND_CLASS		-51
#define JDCS_EJNI_NEW_BYTE_ARRAY	-52
#define JDCS_EJNI_NEW_OBJECT_ARRAY	-53
#define JDCS_EJNI_ALLOC_OBJECT		-54
#define JDCS_EJNI_NEW_GLOBAL_REF	-55

/* コード・タイプ（コード判定ステータス）*/
#define JDCS_UNKNOWN				-1 /* コード・タイプ不明 */
#define JDCS_EMPTY				0 /* 空データ */
#define JDCS_ASCII				1 /* ASCII */
#define JDCS_JIS					2 /* JIS ISO-2022-JP */
#define JDCS_JIS1					3 /* JIS CP50221 */
#define JDCS_JIS2				4 /* JIS ISO-2022-JP-2004 */
#define JDCS_JIS3				5 /* JIS ISO-2022-JP-3 */
#define JDCS_SJIS				6 /* Shift_JIS */
#define JDCS_SJIS1			7 /* CP932 */
#define JDCS_SJIS2			8 /* Shift_JIS-2004 */
#define JDCS_EUC					9 /* EUC-JP */
#define JDCS_EUC1				10 /* EUC CP20932 */
#define JDCS_EUC2				11 /* EUC CP51932 */
#define JDCS_EUC3				12 /* eucJP-ms */
#define JDCS_EUC4				13 /* eucJP-2004 */
#define JDCS_UTF8				20 /* UTF-8 */
#define JDCS_UTF8_BOM			21 /* UTF-8（BOM付）*/
#define JDCS_UTF16BE				22 /* UTF-16 ビッグ・エンディアン */
#define JDCS_UTF16BE_BOM			23 /* UTF-16 ビッグ・エンディアン（BOM付）*/
#define JDCS_UTF16LE				24 /* UTF-16 リトル・エンディアン・ */
#define JDCS_UTF16LE_BOM			25 /* UTF-16 リトル・エンディアン（BOM付）*/
#define JDCS_UTF32BE				26 /* UTF-32 ビッグ・エンディアン */
#define JDCS_UTF32BE_BOM			27 /* UTF-32 ビッグ・エンディアン（BOM付）*/
#define JDCS_UTF32LE				28 /* UTF-32 リトル・エンディアン・ */
#define JDCS_UTF32LE_BOM			29 /* UTF-32 リトル・エンディアン（BOM付）*/
#define JDCS_NORMAL				00000000077	/* 確定コード・タイプの最大値 */

/* 確定コード・タイプ */
#define JDCS_CONFIRMED_CODE_TYPE(sts)	(JDCS_UNKNOWN < (sts) && (sts) <= JDCS_NORMAL)

/* 未確定コード・タイプ（マスク値） */
#define JDCS_ND_ASCII						000000000100 /* ASCII */
#define JDCS_ND_JIS								000000000200 /* JIS ISO-2022-JP */
#define JDCS_ND_JIS1							000000000400 /* JIS CP50221 */
#define JDCS_ND_JIS2							000000001000 /* JIS ISO-2022-JP-2004 */
#define JDCS_ND_JIS3							000000002000 /* JIS ISO-2022-JP-3 */
#define JDCS_ND_JIS_ALL					000000003600 /* JIS ALL */
#define JDCS_ND_SJIS							000000004000 /* Shift_JIS */
#define JDCS_ND_SJIS1						000000010000 /* SJIS CP932 */
#define JDCS_ND_SJIS2						000000020000 /* Shift_JIS-2004 */
#define JDCS_ND_SJIS_ALL      000000034000 /* SJIS ALL */
#define JDCS_ND_EUC							  00000040000 /* EUC-JP */
#define JDCS_ND_EUC1							00000100000 /* EUC CP20932 */
#define JDCS_ND_EUC2							000000200000 /* EUC CP51932 */
#define JDCS_ND_EUC3							000000400000 /* eucJP-ms */
#define JDCS_ND_EUC4							000001000000 /* eucJP-2004 */
#define JDCS_ND_EUC_ALL					000001740000 /* EUC ALL */
#define JDCS_ND_UTF8							000010000000 /* UTF-8 */
#define JDCS_ND_UTF8_BOM				000020000000 /* UTF-8（BOM付）*/
#define JDCS_ND_UTF16BE					000040000000 /* UTF-16 ビッグ・エンディアン */
#define JDCS_ND_UTF16BE_BOM		000100000000 /* UTF-16 ビッグ・エンディアン（BOM付）*/
#define JDCS_ND_UTF16LE					000200000000 /* UTF-16 リトル・エンディアン・ */
#define JDCS_ND_UTF16LE_BOM		000400000000 /* UTF-16 リトル・エンディアン（BOM付）*/
#define JDCS_ND_UTF32BE					001000000000 /* UTF-32 ビッグ・エンディアン */
#define JDCS_ND_UTF32BE_BOM		002000000000 /* UTF-32 ビッグ・エンディアン（BOM付）*/
#define JDCS_ND_UTF32LE					004000000000 /* UTF-32 リトル・エンディアン・ */
#define JDCS_ND_UTF32LE_BOM		010000000000 /* UTF-32 リトル・エンディアン（BOM付）*/
#define JDCS_ND_UTF_BOM			(DCS_ND_UTF8_BOM|DCS_ND_UTF16BE_BOM|DCS_ND_UTF16LE_BOM|DCS_ND_UTF32BE_BOM|DCS_ND_UTF32LE_BOM) /* UTF（BOM付）*/
#define JDCS_ND_ALL				017777777700 /* ND ALL */

/* 変換監視継続、停止ステータス */
#define JDCS_OBS_STOP			-1		/* 変換監視停止 */
#define JDCS_OBS_CONTINUE		0		/* 変換監視継続 */

/* Charset 定義ビット(_unibe_def_table.h マスク値) */
/* UTF 以外は未実装 */
#define JCSB_UTF16				0000001
#define JCSB_UTF8				0000002
#define JCSB_UTF				0000003
#define JCSB_JIS				0000010
#define JCSB_SJIS				0000020
#define JCSB_EUC				0000040
#define JCSB_EUC1				0000100
#define JCSB_EUC2				0000200
#define JCSB_EUC3				0000400
#undef  JCSB_EUC4
#define JCSB_OTHER				0000770
#define JCSB_ALL				0000777
#define JCSB_EX					0001000
#define JCSB_EX2				0002000
#define JCSB_UTFEX			(JCSB_EX | JCSB_UTF)
#define JCSB_UTFEX2		(CSB_EX2 | CSB_UTF)

#ifdef __cplusplus
}
#endif

#endif /* #ifndef JDCS_H_ */
