/*
 * jdcs_convert_buffer.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include <stdlib.h>
#include "_jdcs.h"

JniConvertInfo *_jni_info;

/* 変換監視 */
int _jdcs_observer(int sts, void  *user_info) {
	return (*_jni_info->jenv)->CallIntMethod(_jni_info->jenv,
		_jni_info->jobserver, _jni_info->mid_ob, sts, user_info);
}

/* 変換出力 */
int _jdcs_writer(const char *buf, size_t size, void  *user_info) {
	/* バイト配列を生成 */
	(*_jni_info->jenv)->SetByteArrayRegion(_jni_info->jenv, _jni_info->jbuf, 0, size, (void *)buf);
	return (*_jni_info->jenv)->CallIntMethod(_jni_info->jenv,
		_jni_info->jwriter, _jni_info->mid_wr, _jni_info->jbuf, size, user_info);
}

/*
 * Class:     rabbit_dcs_Dcs
 * Method:    convertBuffer
 * Signature: ([BIIIZLrabbit/dcs/ConvertObserver;Lrabbit/dcs/ConvertWriter;Ljava/lang/Object;)I
 */
JNIEXPORT jint JNICALL Java_rabbit_dcs_Dcs_convertBuffer
  (JNIEnv *jenv, jobject jobj, jbyteArray jbuf, jint jlength,
	jint jstype, jint jdtype, jboolean jisForced, jobject jobserver, jobject jwriter, jobject user_info) {
	_JDcsInfo *info;
	char *ptr;
	int sts, len;
	jclass obcls, wrcls;
	JniConvertInfo *jni_info;

	GET_DCS_INFO_BY_OBJECT(jenv, jobj, info);
	if ((info->dcs->_jni_info = jni_info = _jni_info = calloc(sizeof(JniConvertInfo), 1)) == NULL) {
		sts = DCS_EALLOC;
	} else {
		if (jobserver != NULL) {
			obcls = (*jenv)->GetObjectClass(jenv, jobserver);
			jni_info->mid_ob = (*jenv)->GetMethodID(jenv, obcls, "observe", OBSERVER_SIGNATURE);
		}
		if (jwriter != NULL) {
			wrcls = (*jenv)->GetObjectClass(jenv, jwriter);
			jni_info->mid_wr = (*jenv)->GetMethodID(jenv, wrcls, "write", WRITER_SIGNATURE);
		}
		jni_info->jenv = jenv;
		jni_info->jobj = jobj;
		jni_info->info = info;
		jni_info->jobserver = jobserver;
		jni_info->jwriter = jwriter;
		jni_info->jbuf = (*jenv)->NewByteArray(jenv, _SBUF_SIZE);
		ptr = (char *)(*jenv)->GetByteArrayElements(jenv, jbuf, NULL);
		len = min(jlength, (*jenv)->GetArrayLength(jenv, jbuf));

		_set_data_type(info->dcs, _DTYPE_JNI_BUFFER);
		sts = dcs_convert_buffer(info->dcs, ptr, len, jstype, jdtype, jisForced,
				jobserver == NULL? NULL: _jdcs_observer, jwriter == NULL? NULL: _jdcs_writer, user_info);
		_clear_data_type(info->dcs, _DTYPE_JNI_BUFFER);

		(*jenv)->ReleaseByteArrayElements(jenv, jbuf, (jbyte *)ptr, 0);
		free(info->dcs->_jni_info);
		info->dcs->_jni_info = NULL;
	}
	return SET_AND_RETURN_STS(jenv, jobj, info, sts);
}
