/*
 * jdcs_convert_stream.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_jdcs.h"

extern JniConvertInfo *_jni_info;

/* 変換監視 */
extern int _jdcs_observer(int sts, void *user_info);

/* 変換出力 */
extern int _jdcs_writer(const char *buf, size_t size, void *user_info);

/*
 * Class:     rabbit_dcs_Dcs
 * Method:    convertStream
 * Signature: (Ljava/io/InputStream;IIZLrabbit/dcs/ConvertObserver;Lrabbit/dcs/ConvertWriter;Ljava/lang/Object;)I
 */
JNIEXPORT jint JNICALL Java_rabbit_dcs_Dcs_convertStream
  (JNIEnv *jenv, jobject jobj, jobject jistream,
	jint jstype, jint jdtype, jboolean jisForced, jobject jobserver, jobject jwriter, jobject user_info) {
	_JDcsInfo *info;
	int sts;
	jclass iscls;
	jclass obcls, wrcls;
	JniConvertInfo *jni_info;

	GET_DCS_INFO_BY_OBJECT(jenv, jobj, info);
	if ((info->dcs->_jni_info = jni_info = _jni_info = calloc(sizeof(JniConvertInfo), 1)) == NULL) {
		sts = DCS_EALLOC;
	} else {
		if (jobserver != NULL) {
			obcls = (*jenv)->GetObjectClass(jenv, jobserver);
			jni_info->mid_ob = (*jenv)->GetMethodID(jenv, obcls, "observe", OBSERVER_SIGNATURE);
		}
		if (jwriter != NULL) {
			wrcls = (*jenv)->GetObjectClass(jenv, jwriter);
			jni_info->mid_wr = (*jenv)->GetMethodID(jenv, wrcls, "write", WRITER_SIGNATURE);
		}
		iscls = (*jenv)->GetObjectClass(jenv, jistream);
		jni_info->mid_buf = (*jenv)->GetMethodID(jenv, iscls, "read", "([BII)I");
		jni_info->mid_char = (*jenv)->GetMethodID(jenv, iscls, "read", "()I");
		jni_info->jenv = jenv;
		jni_info->jobj = jobj;
		jni_info->info = info;
		jni_info->jistream = jistream;
		jni_info->jobserver = jobserver;
		jni_info->jwriter = jwriter;
		jni_info->jbuf = (*jenv)->NewByteArray(jenv, _SBUF_SIZE);

		_set_data_type(info->dcs, _DTYPE_JNI_STREAM);
		sts = dcs_convert_stream(info->dcs, NULL, jstype, jdtype, jisForced,
				jobserver == NULL? NULL: _jdcs_observer, jwriter == NULL? NULL: _jdcs_writer, user_info);
		_clear_data_type(info->dcs, _DTYPE_JNI_STREAM);

		free(info->dcs->_jni_info);
		info->dcs->_jni_info = NULL;
	}
	return SET_AND_RETURN_STS(jenv, jobj, info, sts);
}
