/*
 * jdcs_create_dcs.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_jdcs.h"

/*
 * Class:	 rabbit_dcs_Dcs
 * Method:	_createDcs
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_rabbit_dcs_Dcs__1createDcs
  (JNIEnv *jenv, jobject jobj) {
	_JDcsInfo *info;
	Dcs *dcs;

	jclass jcls = (*jenv)->GetObjectClass(jenv, jobj);
	jfieldID hdcsInfoID = (*jenv)->GetFieldID(jenv, jcls, _HDCS_INFO_NAME, "J");

	(*jenv)->SetLongField(jenv, jobj, hdcsInfoID, (jlong)0);
	dcs = create_dcs();
	if (dcs == NULL) {
		return JDCS_EALLOC;
	}
	info = calloc(sizeof(_JDcsInfo), 1);
	if (info == NULL) {
		release_dcs(dcs);
		return JDCS_EALLOC;
	}
	(*jenv)->SetLongField(jenv, jobj, hdcsInfoID, (jlong)info);
	info->env = jenv;
	info->obj = jobj;
	info->cls = jcls;
	info->dcs = dcs;
	info->stsID = (*jenv)->GetFieldID(jenv, jcls, "sts", "I");
	info->versionID = (*jenv)->GetStaticFieldID(jenv, jcls, _VERSION_NAME, "F");
	(*jenv)->SetStaticFloatField(jenv, jcls, info->versionID, (jfloat)dcs->version);
	return SET_AND_RETURN_STS(jenv, jobj, info, JDCS_SUCCESS);
}
