/*
 * jdcs_judges_buffer.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_jdcs.h"

/*
 * Class:     rabbit_dcs_Dcs
 * Method:    judgesBuffer
 * Signature: ([I[I[BII)I
 */
JNIEXPORT jint JNICALL Java_rabbit_dcs_Dcs_judgesBuffer
  (JNIEnv *jenv, jobject jobj,
	jintArray jatype, jintArray jln_type, jbyteArray jbuf, jint jlength, jint jstype) {
	_JDcsInfo *info;
	int sts, len;
	int *patype, *pln_type;
	char *ptr;

	GET_DCS_INFO_BY_OBJECT(jenv, jobj, info);
	patype   = (jatype   == NULL? NULL: (int *)(*jenv)->GetIntArrayElements(jenv, jatype, NULL));
	pln_type = (jln_type == NULL? NULL: (int *)(*jenv)->GetIntArrayElements(jenv, jln_type, NULL));
	ptr = (char *)(*jenv)->GetByteArrayElements(jenv, jbuf, NULL);
	len = min(jlength, (*jenv)->GetArrayLength(jenv, jbuf));

	_set_data_type(info->dcs, _DTYPE_JNI_BUFFER);
	sts = dcs_judges_buffer(info->dcs, patype, pln_type, ptr, len, jstype);
	_clear_data_type(info->dcs, _DTYPE_JNI_BUFFER);

	if (jatype != NULL) {
		(*jenv)->ReleaseIntArrayElements(jenv, jatype, (long *)patype, 0);
	}
	if (jln_type != NULL) {
		(*jenv)->ReleaseIntArrayElements(jenv, jln_type, (long *)pln_type, 0);
	}
	(*jenv)->ReleaseByteArrayElements(jenv, jbuf, ptr, 0);
	return SET_AND_RETURN_STS(jenv, jobj, info, sts);
}
