/*
 * jdcs_judges_file.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_jdcs.h"

/*
 * Class:     rabbit_dcs_Dcs
 * Method:    judgesFile
 * Signature: ([I[I[BI)I
 */
JNIEXPORT jint JNICALL Java_rabbit_dcs_Dcs_judgesFile
  (JNIEnv *jenv, jobject jobj,
	jintArray jatype, jintArray jln_type, jbyteArray jpath, jint jstype) {
	_JDcsInfo *info;
	int sts, len;
	int *patype, *pln_type;
	char path[PATH_MAX];

	GET_DCS_INFO_BY_OBJECT(jenv, jobj, info);
	patype   = (jatype   == NULL? NULL: (int *)(*jenv)->GetIntArrayElements(jenv, jatype, NULL));
	pln_type = (jln_type == NULL? NULL: (int *)(*jenv)->GetIntArrayElements(jenv, jln_type, NULL));
	len = min(sizeof(path) - 1, (*jenv)->GetArrayLength(jenv, jpath));
	(*jenv)->GetByteArrayRegion(jenv, jpath, 0, len, path);
	*(path + len) = 0;

	_set_data_type(info->dcs, _DTYPE_JNI_FILE);
	sts = dcs_judges_file(info->dcs, patype, pln_type, path, jstype);
	_clear_data_type(info->dcs, _DTYPE_JNI_FILE);

	if (jatype != NULL) {
		(*jenv)->ReleaseIntArrayElements(jenv, jatype, (long *)patype, 0);
	}
	if (jln_type != NULL) {
		(*jenv)->ReleaseIntArrayElements(jenv, jln_type, (long *)pln_type, 0);
	}
	return SET_AND_RETURN_STS(jenv, jobj, info, sts);
}
