/*
 * jdcs_judges_stream.c
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

#include "_jdcs.h"

/*
 * Class:     rabbit_dcs_Dcs
 * Method:    judgesStream
 * Signature: ([I[ILjava/io/InputStream;I)I
 */
JNIEXPORT jint JNICALL Java_rabbit_dcs_Dcs_judgesStream
  (JNIEnv *jenv, jobject jobj,
	jintArray jatype, jintArray jln_type, jobject jistream, jint jstype) {
	_JDcsInfo *info;
	int sts;
	jclass iscls;
	int *patype, *pln_type;
	JniJudgedStreamInfo *jni_info;

	GET_DCS_INFO_BY_OBJECT(jenv, jobj, info);
	if ((info->dcs->_jni_info = calloc(sizeof(JniJudgedStreamInfo), 1)) != NULL) {
		patype   = (jatype   == NULL? NULL: (int *)(*jenv)->GetIntArrayElements(jenv, jatype, NULL));
		pln_type = (jln_type == NULL? NULL: (int *)(*jenv)->GetIntArrayElements(jenv, jln_type, NULL));

		jni_info = (JniJudgedStreamInfo *)info->dcs->_jni_info;
		jni_info->jbuf = (*jenv)->NewByteArray(jenv, _SBUF_SIZE);
		iscls = (*jenv)->GetObjectClass(jenv, jistream);
		jni_info->mid_buf = (*jenv)->GetMethodID(jenv, iscls, "read", "([BII)I");
		jni_info->mid_char = (*jenv)->GetMethodID(jenv, iscls, "read", "()I");
		jni_info->jenv = jenv;
		jni_info->jobj = jobj;
		jni_info->jistream = jistream;

		_set_data_type(info->dcs, _DTYPE_JNI_STREAM);
		sts = dcs_judges_stream(info->dcs, patype, pln_type, NULL, jstype);
		_clear_data_type(info->dcs, _DTYPE_JNI_STREAM);

		if (jatype != NULL) {
			(*jenv)->ReleaseIntArrayElements(jenv, jatype, (long *)patype, 0);
		}
		if (jln_type != NULL) {
			(*jenv)->ReleaseIntArrayElements(jenv, jln_type, (long *)pln_type, 0);
		}
		free(info->dcs->_jni_info);
		info->dcs->_jni_info = NULL;
	}
	return SET_AND_RETURN_STS(jenv, jobj, info, sts);
}
