/*
 * ConvertObserver.java
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

/**
 *
 */
package rabbit.dcs;

/**
 *  &nbsp;&nbsp;&nbsp;&nbsp;<font size=+1><code>ConvertObserver</code></font> は Dcs.convertBuffer() 等のコード変換メソッドの引き数として渡します。
 *  変換前のコード判定が終了した時点で、observe() が呼び出され、
 *  変換が終わるまで、編集バッファがフルになる度に ConvertWriter.write() が呼び出されます。
 *  observe() の処理が不要ならば null を設定します。
 *
 * @author rabbit
 * @since 2.0
*/
public interface ConvertObserver {
	/**
     *  Dcs.convertBuffer() 等のコード変換前のコード判定が終了した時点で、
     *  引き数で渡される判定結果 sts により必ず１回呼び出されます。
     *  継続ならば Dcs.OBS_CONTINUE、中止する時は OBS_STOP で戻ります。<br>
     *  &nbsp;&nbsp;&nbsp;&nbsp;致命的なエラーや入力データの文字コード・タイプが確定できなかった（Dcs.CONFIRMED_CODE_TYPE(sts)が偽）場合は判定結果がコード変換メソッドの返却値となり、
     *  observe() が Dcs.OBS_CONTINUE を返しても継続されません。<br>
     *  &nbsp;&nbsp;&nbsp;&nbsp;変換結果をファイルに出力する場合は observe() がそのファイルをオープンし、ConvertWriter.write() で書き込み、Dcs.convertBuffer() 等から返った後、呼び出し側でクローズします。<br>
     *  &nbsp;&nbsp;&nbsp;&nbsp;userInfo は Dcs.convertBuffer() 等の呼び出し時に渡されるユーザー情報です。<br>
	 * @param sts コード判定結果のステータス
	 * @param userInfo ユーザー情報
	 * @return 継続ならば Dcs.OBS_CONTINUE、中止する時は Dcs.OBS_STOP を返します。
	 *
	 */
	public int observe(int sts, Object userInfo);
}
