/*
 * ConvertWriter.java
 *
 * Copyright 2019-2026 Ichiji Tadokoro. All Rights Reserved.
 */

/**
 *
 */
package rabbit.dcs;

/**
 *  &nbsp;&nbsp;&nbsp;&nbsp;<font size=+1><code>ConvertWriter</code></font> は Dcs.convertBuffer() 等のコード変換メソッドの引き数として渡します。
 *  変換前のコード判定が終了した時点で、ConvertObserver.observe() が呼び出され、
 *  変換が終わるまで、編集バッファがフルになる度に writer() が呼び出されます。
 *  write() の処理が不要ならば null を設定します。
 *
 * @author rabbit
 * @since 2.0
 */
public interface ConvertWriter {
	/**
     *  &nbsp;&nbsp;&nbsp;&nbsp;Dcs.convertBuffer() 等のコード変換中に編集バッファがフルになる度に呼び出され、
     *  引き数で渡される出力バッファ buffer、出力サイズ length により実際の出力を行ないます。
     *  出力が成功したら Dcs.SUCCESS、ファイル出力エラーなら Dcs.EWRITE、
     *  メモリー・アロケート・エラーならば Dcs.EALLOC で戻ります。<br>
     *  &nbsp;&nbsp;&nbsp;&nbsp;write() の返却値が SUCCESS ならば継続され、それ以外の値なら中断されます。
     *  最後の呼び出しの場合、これらはコード変換メソッドの返却値となります。
     *  &nbsp;&nbsp;&nbsp;&nbsp;userInfo は Dcs.convertBuffer() 等の呼び出し時に渡されるユーザー情報です。<br>
	 * @param buffer 出力バッファ
	 * @param length 出力サイズ
	 * @param userInfo ユーザー情報
	 * @return 出力が成功したら Dcs.SUCCESS、ファイル出力エラーなら Dcs.EWRITE、
     *  メモリー・アロケート・エラーならば Dcs.EALLOC を返します。
	 *
	 */
	public int write(byte[] buffer, int length, Object userInfo);
}
