/*
 * HelloJdcs.java
 *
 * Copyright 2019-2022 Ichiji Tadokoro. All Rights Reserved.
 */
package rabbit.jdcs_test;

import java.io.UnsupportedEncodingException;

import rabbit.dcs.ConvertObserver;
import rabbit.dcs.ConvertWriter;
import rabbit.dcs.Dcs;

/**
 * @author rabbit
 *
 */
public class HelloJdcs implements ConvertObserver, ConvertWriter {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			new HelloJdcs().execute();
		} catch(Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
		System.exit(0);
	}

	/**
	 *
	 */
	public HelloJdcs() {
	}

	public void execute() {
		try {
			byte[] hbuf = "今日は、皆さん！".getBytes("ms932");
			print("ms932", hbuf, hbuf.length);
			Dcs dcs = new Dcs();
			dcs.convertBuffer(hbuf, hbuf.length, Dcs.UNKNOWN, Dcs.UTF8, false, this, this, null);
			dcs.close();
		} catch(Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	void print(String name, byte[] buf, int length) {
		StringBuffer sb = new StringBuffer();
		System.out.println(name);
		sb.append("[");

		for(int i=0;i<length;i++) {
			sb.append(String.format("%02x ", buf[i]));
		}
		sb.append("]");
		System.out.println(sb);
	}

	@Override
	public int observe(int sts, Object userInfo) {
		return Dcs.OBS_CONTINUE;
	}

	@Override
	public int write(byte[] buffer, int length, Object userInfo) {
		// UTF-8 "今日は、皆さん！"
		try {
			System.out.println(new String(buffer, 0, length, "utf-8"));
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		print("UTF-8", buffer, length);
		return Dcs.SUCCESS;
	}
}
