﻿using System;
using System.IO;
using eRxQRCodeGenerator;

// QRコード生成サンプル
// 本ファイルは DLL 利用方法の説明用サンプルです。

string csv = "ここにJHIS処方箋QRコード用データ文字列";

// 出力フォルダ
//outputDirが空白またはnullの場合はファイルは作られません。
//指定した場合はフォルダ内に、qr_1.png, qr_2.png　のようにqr_XXX.pngという名前で出力されます。
//string outputDir = null;
string outputDir = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.Desktop),"eRxQR_Output");
Directory.CreateDirectory(outputDir);

// QRジェネレータ初期化
var gen = new eRxQrGenerator()
{
    Version = 11,
    ErrorLevel = 0, // L
    ModuleSize = 3
};

// QRコードを生成します。outputDirを指定している場合はここでファイルが出力されます。
var result = gen.Generate(csv, outputDir);

// エラーチェック
if (result.ErrorMessage != null)
{
    Console.WriteLine("QR生成エラー:");
    Console.WriteLine(result.ErrorMessage);
    return;
}

// outputDir を指定した場合、DLL 側で PNG ファイルが自動出力されます。
// result.Images には PNG形式の byte[] が格納されます。
// これらのデータはファイルに保存せず、
// メモリ上でそのまま他のモジュールやアプリケーションへ
// 受け渡す用途にも利用できます。
int index = 1;
foreach (var bytes in result.Images)
{
    string path = Path.Combine(outputDir, $"qr_{index}.png");
    File.WriteAllBytes(path, bytes);
    index++;
}

Console.WriteLine("QRコード生成完了");
