/** newguid.cpp
 * GUID𐶐
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @	MinGW C++ + Boost C++ Libraries
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-10-01.shtm
 * IvV	RpCXCb` CMDAPP w肷CUIł𐶐
 *
*/
//  ======================================================
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <sstream>
#include <string>
#include <fstream>
#include <winsock2.h>
#include <windows.h>
#include <commctrl.h>
#include <shlobj.h>
#include <richedit.h>
#include <boost/program_options.hpp>
#include <boost/property_tree/xml_parser.hpp>
#include <boost/format.hpp>
#include "resource.h"

using namespace std;
using namespace boost;
using namespace boost::program_options;
using namespace boost::property_tree;

#define APPNAME		"newguid"		// AvP[ViGUIŁj
#define APPNAMEJP	"GUID"		// AvP[Vi{j
#define APPCMD		"nguid"			// AvP[ViCUIŁj
#define APPVERSION	"1.4.9"			// o[W
#define APPYEAR		"2020-2026"		// 쐬N
#define REFERENCE	"https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-10-01.shtm"	// QlTCg

// char*obt@TCY
#define SIZE_BUFF		5120

// WtHg
#define FONT_FACE		"MS UI Gothic"

// ݂̃C^[tFCX
HINSTANCE hInst;

// AvP[VEEBhE
HWND hParent;

// AvP[VEEBhEʒu
unsigned hParent_X, hParent_Y;

// G[EbZ[Wi[p
string ErrorMessage;

// wvEt@C
#define HELPFILE	".\\etc\\help.chm"

// ftHgۑt@C
#define SAVEFILE	"newguid.txt"

// IvV
#define OPTION_ADD_BRACE	'b'		// {...} ǉ
#define OPTION_TRIM_HYPHEN	't'		// nCt폜

// IvV̏l
#define OPTION_INIT			""

// GUID̍ŏƍő吔
#define MIN_GUID	1
#define MAX_GUID	10

// GUID̐
unsigned GuidNum = MIN_GUID;

// GUIDۊǂz
string Guid[MAX_GUID];

// o[W
string Version = (boost::format(R"(
%1%  o[W %2%

{AvP[VMIT LicensełD
p܂ޖp\łDRɉł܂D
Ĕzz̍ۂ́CL̒쌠\LCURLƖ{gpKLĂD

@Copyright by (c)studio pahoo, %3%
@https://www.pahoo.org/

ȂC{AvP[V̗p܂͉邱ƂɂĐĂ͈؊֒m܂DAPI̕ύXE~ɂĐɋ@\ȂȂꍇ܂D܂C񎟗p̑gDEƁEĉ̖ړIEeEɂĂ͈؊֒m܂D

{AvP[V́CL̃Cu𗘗pĂ܂D
@MinGW(g++), Boost C++Cu
)")
% APPNAMEJP
% APPVERSION
% APPYEAR
).str();

// CUIwv
string Help = (boost::format(R"(
%1%  o[W %2%

%3%.exe -IvV
        -n, --num     GUID̐il%4%j
        -b, --brace   {...} ǉ
        -t, --trim    nCt폜
        -d, --dest    eLXgt@C֏o
        -p, --paste   Nbv{[h֏o
        -v, --version o[W
        -h, --help    ICwv

ij%3% -n5 -t  GUID5CnCt폜`Ő
)")
% APPNAMEJP
% APPVERSION
% APPCMD
% MIN_GUID
).str();

// Nbv{[h֘A ======================================================
/**
 * Nbv{[hɕZbgD
 * @param	string str 
 * @return	Ȃ
*/
void setClipboardData(string str) {
	char buff[str.size() + 1];
	char_traits<char>::copy(buff, str.c_str(), str.size() + 1);

	OpenClipboard(NULL);
	EmptyClipboard();

	HGLOBAL hText = GlobalAlloc(GHND | GMEM_SHARE, SIZE_BUFF);
	PTSTR pText = (PTSTR)GlobalLock(hText);
	lstrcpy(pText, buff);
	GlobalUnlock(hText);
	SetClipboardData(CF_TEXT, hText);
	CloseClipboard();
}

/**
 * Nbv{[h當擾D
 * @param	Ȃ
 * @return	^NULL擾s
*/
char* getClipboardData(void) {
	static char buff[SIZE_BUFF + 1];

	OpenClipboard(NULL);
	HGLOBAL hText = GetClipboardData(CF_TEXT);

	if (hText == NULL) {
		return NULL;
	} else {
		PTSTR pText = (PTSTR)GlobalLock(hText);
		lstrcpy(buff, pText);
		GlobalUnlock(hText);
	}
	CloseClipboard();

	return buff;
}

// GUID ==================================================================
#define BIT_BRACE	2		// u[XǉtO
#define BIT_HYPHEN	1		// nCtȗtO

/**
 * GUID1D
 * fmtɎw肷lɂāCnCtu[X̗LwłD
 * ftHg̓nCtCu[XD
 * @param	int fmt ̏ID
 *						0Fʏ, 1FnCt, 2Fu[XLCnCtL
 *						3Fu[XLCnCt
 * @return	string GUID^NULLFs
*/
string newGUID(int fmt=0) {
	GUID guid;
	static char buff[SIZE_BUFF + 1];
	// ̏
	const char *format[] = {
		"%08lX-%04X-%04X-%02X%02X-%02X%02X%02X%02X%02X%02X",
		"%08lX%04X%04X%02X%02X%02X%02X%02X%02X%02X%02X",
		"{%08lX-%04X-%04X-%02X%02X-%02X%02X%02X%02X%02X%02X}",
		"{%08lX%04X%04X%02X%02X%02X%02X%02X%02X%02X%02X}"
	};
	if ((fmt < 0) || (fmt > (int)sizeof(format))) {
		ErrorMessage = "̏s";
		return "";
	}

	// GUID̐iWindows APIpj
	if (S_OK != ::CoCreateGuid(&guid)) {
		ErrorMessage = "GUIDɎs";
		return "";
	} else {
		snprintf(buff, SIZE_BUFF, format[fmt], guid.Data1, guid.Data2, guid.Data3, guid.Data4[0],guid.Data4[1],guid.Data4[2],guid.Data4[3], guid.Data4[4], guid.Data4[5], guid.Data4[6], guid.Data4[7]);
	}

	return (string)buff;
}

#ifndef CMDAPP
// GUI =================================================================
/**
 * w肵eLXg{bNXɎw肵D
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @param  string	s     ݒl
 * @return Ȃ
*/
void setStrEditBox(HWND hDlg, unsigned id, string s) {
	char buff[SIZE_BUFF + 1];
	char_traits<char>::copy(buff, s.c_str(), s.size() + 1);
	SetDlgItemText(hDlg, id, buff);
}

/**
 * w肵eLXg{bNXɂ镶擾D
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @return string 擾
*/
string getStrEditBox(HWND hDlg, unsigned id) {
	char buff[SIZE_BUFF];
	GetDlgItemText(hDlg, id, buff, sizeof(buff));
	return (string)buff;
}

/**
 * w肵eLXg{bNXɂ鐮擾D
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @return int 擾l
*/
int getIntEditBox(HWND hDlg, unsigned id) {
	char buff[SIZE_BUFF + 1];
	GetDlgItemText(hDlg, id, buff, sizeof(buff));

	return atoi(buff);
}

/**
 * w肵eLXg{bNXɎw肵D
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @param  int		i     ݒl
 * @return Ȃ
*/
void setIntEditBox(HWND hDlg, unsigned id, int i) {
	char buff[SIZE_BUFF + 1];
	snprintf(buff, sizeof(buff), "%d", i);
	SetDlgItemText(hDlg, id, buff);
}

/**
 * w肵_CAOeEBhE̒ɔzuD
 * @param	HWND hDlg		̃nh
 * @global	HWND hParent	eEBhẼnh
 * @return	Ȃ
*/
void CenterWindow(HWND hDlg) {
	int  x, y;
	RECT rc;

	GetWindowRect(hParent, &rc);
	x = rc.left + (rc.right - rc.left) / 2;
	y = rc.top + (rc.bottom - rc.top) / 2;

	SetWindowPos(hDlg, NULL, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
}

// IvVǍ^ۑ ====================================================
/**
 * AppDatãpX擾D
 * @param	char* appname AvP[V
 * @return	string pX
 */
string getMyPath(const char* appname) {
	static TCHAR myPath[MAX_PATH] = "";

	if (strlen(myPath) == 0) {
		if (SHGetSpecialFolderPath(NULL, myPath, CSIDL_APPDATA, 0)) {
			TCHAR *ptmp = _tcsrchr(myPath, _T('\\'));
			if (ptmp != NULL) {
				ptmp = _tcsinc(ptmp);
				*ptmp = _T('\0');
			}
			strcat(myPath, _T("Roaming"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\pahoo.org"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
			strcat(myPath, _T(appname));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
		} else {
		}
	}
	return (string)myPath;
}

/**
 * p[^D
 * ̂̓O[oϐD
 * @param	Ȃ
 * @return	Ȃ
 */
void initParameter(void) {
	hParent_X = 0;
	hParent_Y = 0;
	GuidNum   = MIN_GUID;
}

/**
 * AppDataɕۑp[^ǂݍŃO[oϐɊi[D
 * @param	Ȃ
 * @return	string IvV
 */
string loadParameter(void) {
	string option = OPTION_INIT;
	ptree pt;

	// lݒ
	initParameter();

	// XMLt@Cǂݍ
	try {
		xml_parser::read_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt);

		// XML
		try {
			// ``FbN
			if (boost::optional<std::string>str = pt.get_optional<string>("parameter")) {
			} else {
				return OPTION_INIT;
			}
			// p[^ǂݍ
			for (auto it : pt.get_child("parameter")) {
				string type= it.second.get_optional<string>("<xmlattr>.type").value();
				if (type == "num") {
					GuidNum = (unsigned)stoi(it.second.data());
				} else if (type == "option") {
					option =(string)it.second.data();
				} else if (type == "wx") {
					hParent_X = (unsigned)stoi(it.second.data());
				} else if (type == "wy") {
					hParent_Y = (unsigned)stoi(it.second.data());
				}
			}
		// ߎs珉lݒ
		} catch (xml_parser_error& e) {
			initParameter();
			return OPTION_INIT;
		}
	// ǂݍݎs珉lݒ
	} catch (xml_parser_error& e) {
		initParameter();
		return OPTION_INIT;
	}

	// AvP[VEEBhËʒuifXNgbv͈͊OȂ猴_ړj
	HWND hDesktop = GetDesktopWindow();
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hDesktop, &windowInfo);
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}

	return option;
}

/**
 * AppDataɃp[^ۑD
 * @param	string option IvV
 * @return	Ȃ
 */
void saveParameter(string option) {
	// AvP[VEEBhËʒu擾
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hParent, &windowInfo);
	hParent_X = (unsigned)windowInfo.rcWindow.left;
	hParent_Y = (unsigned)windowInfo.rcWindow.top;
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}

	// XMLt@C֏
	ptree pt;
	ptree& child1 = pt.add("parameter.param", (string)to_string(GuidNum));
	child1.add("<xmlattr>.type", "num");
	ptree& child2 = pt.add("parameter.param", option);
	child2.add("<xmlattr>.type", "option");
	ptree& child3 = pt.add("parameter.param", (string)to_string(hParent_X));
	child3.add("<xmlattr>.type", "wx");
	ptree& child4 = pt.add("parameter.param", (string)to_string(hParent_Y));
	child4.add("<xmlattr>.type", "wy");

	const int indent = 4;
	write_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt, std::locale(),
		xml_writer_make_settings<std::string>(' ', indent));
}

/**
 * AppDatãp[^ۑt@C폜D
 * p[n𔽉fijɂ̓vO̍ċNKvD
 * @param	Ȃ
 * @return	Ȃ
 */
void delParameter(void) {
	remove((getMyPath(APPNAME) + APPNAME + ".xml").c_str());

	// lݒ
	initParameter();
}

// IvV擾Eݒ ======================================================
/**
 * w肵IvVݒ肷D
 * @param	HWND hDlg	EBhEEnh
 * @param	string opt	IvV
 * @return	Ȃ
 */
void setOption(HWND hDlg, string opt) {
	for (int i = 0; i < (int)opt.length(); i++) {
		char* ch = (char*)opt.substr(i, 1).c_str();
		switch (*ch) {
		case OPTION_ADD_BRACE:
			SendMessage(GetDlgItem(hDlg, IDC_CHECK_BRACE),
							BM_SETCHECK, BST_CHECKED, 0);
			break;
		case OPTION_TRIM_HYPHEN:
			SendMessage(GetDlgItem(hDlg, IDC_CHECK_HYPHEN),
							BM_SETCHECK, BST_CHECKED, 0);
			break;
		default:
			break;
		}
	}
}

/**
 * IvV擾D
 * @param	HWND hDlg	EBhEEnh
 * @return	string IvV
 */
string getOption(HWND hDlg) {
	string opt = "";
	if (SendMessage(GetDlgItem(hDlg, IDC_CHECK_BRACE), BM_GETCHECK, 0, 0)) {
		opt += OPTION_ADD_BRACE;
	}
	if (SendMessage(GetDlgItem(hDlg, IDC_CHECK_HYPHEN), BM_GETCHECK, 0, 0)) {
		opt += OPTION_TRIM_HYPHEN;
	}

	return opt;
}

// eLXgEt@C֏o =================================================
/**
 * GUIDw肵t@CɕۑD
 * @param	const char* fname ۑt@C
 * @return	Ȃ
*/
void __saveTXT(const char* fname) {
	ofstream outputfile(fname);

	for (int i = 0; i < MAX_GUID; i++) {
		if (Guid[i] != "") {
			outputfile << Guid[i] << endl;
		}
		if (outputfile.bad()) {
			ErrorMessage = "eLXgt@C݃G[";
			break;
		}
	}
	outputfile.close();
}

/**
 * t@C_CAOgGUIDTXTt@CɕۑD
 * @param	Ȃ
 * @return	Ȃ
*/
void saveTXT(void) {
	static char fname[MAX_PATH + 1];
	strcpy(fname, SAVEFILE);
	OPENFILENAME of;

	// OPENFILENAME\̂̃TCYZbg
	memset(&of, 0, sizeof(OPENFILENAME));
	of.lStructSize = sizeof(OPENFILENAME);
	// _CAO{bNXLEBhEւ̃nh
	of.hwndOwner = hParent;
	of.lpstrFilter = TEXT("eLXgt@C(*.txt)\0*.txt\0ׂẴt@C(*.*)\0*.*\0\0");
	// t@Ci[obt@̃AhX
	of.lpstrFile = (LPTSTR)fname; 
	// lpstrFileoŎw肳obt@̃TCY
	of.nMaxFile = MAX_PATH;
	of.Flags = OFN_OVERWRITEPROMPT;
	// ftHg̊gqi[obt@̃AhX
	of.lpstrDefExt = TEXT("txt");
	// R_CAO̕\
	GetSaveFileName(&of);
	// t@Cۑ
	__saveTXT(fname);
}

// o[W\_CAO =================================================
/**
 * CxgnhFo[W\_CAO
 * @param	HWND hDlg	EBhEEnh
 * @paramm	UINT uMsg
 * @param	WPARAM wParam
 * @paramL	PARAM lParam
 * @return	INT_PTR CALLBACK
*/
INT_PTR CALLBACK processHelp(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	string help;

	switch(uMsg){
		// _CAO
		case WM_INITDIALOG:
			CenterWindow(hDlg);
			setStrEditBox(hDlg, IDC_TEXT_HELP, Version);
			break;

		// {^
		case WM_COMMAND:
			 switch (LOWORD(wParam)) {
				// s
				case IDC_BUTTON_OK:
					EndDialog(hDlg, 0);
					break;
				default:
					return 1;
			}
			break;
		// vOI
		case WM_CLOSE:
			EndDialog(hDlg, 0);
			break;
	}
    return 0;
}

/**
 * wvE_CAO쐬
 * @param  HWND hDlg		eEBhEEnh
 * @param  DLGPROC handler	CxgEnh
 * @return Ȃ
*/
void createHelp(HWND hDlg, DLGPROC handler) {
	DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_VER), hDlg, (DLGPROC)handler);
}

// CEBhE ==========================================================
/**
 * CxgnhFCEBhE
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
*/
INT_PTR CALLBACK processMain(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	LPNMUPDOWN lpnmud;
	HICON hIcon;
	static string option = OPTION_INIT;
	unsigned i;
	int fmt = 0;
	string guids = "";

	switch(uMsg){
	// _CAO
	case WM_INITDIALOG:
		hParent = hDlg;
		hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON, 16, 16, 0);
		SendMessage(hParent, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);
		// IvVǂݍ
		option = loadParameter();
		setIntEditBox(hDlg, IDC_EDIT_NUM, GuidNum);
		setOption(hDlg, option);
		// AvP[VEEBhEړ
		SetWindowPos(hParent, NULL, hParent_X, hParent_Y, 0, 0, (SWP_NOSIZE | SWP_NOZORDER | SWP_NOOWNERZORDER));
		break;

	// {^
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		// s
		case IDM_EXEC:
		case IDC_BUTTON_EXEC:
			// 
			ErrorMessage = "";
			for (i = 0; i < MAX_GUID; i++) {
				Guid[i] = "";
			}
			guids = "";
			// 
			GuidNum = getIntEditBox(hDlg, IDC_EDIT_NUM);
			// `FbN{bNX
			if (SendMessage(GetDlgItem(hDlg, IDC_CHECK_BRACE), BM_GETCHECK, 0, 0)) {
				fmt |= BIT_BRACE;
			}
			if (SendMessage(GetDlgItem(hDlg, IDC_CHECK_HYPHEN), BM_GETCHECK, 0, 0)) {
				fmt |= BIT_HYPHEN;
			}
			// GUID
			if ((GuidNum >= MIN_GUID) && (GuidNum <= MAX_GUID)) {
				for (i = 0; i < GuidNum; i++) {
					Guid[i] = newGUID(fmt);
					guids = guids + Guid[i] + "\n";
				}
				setStrEditBox(hDlg, IDC_EDIT_GUID, guids);
			}
			break;
		// ۑ
		case IDC_BUTTON_SAVE:
		case IDM_SAVE:
			saveTXT();
			break;
		// ݒNA{AvI
		case IDM_CLEAR_PARAMETER:
			delParameter();
			EndDialog(hParent, 0);
			return 0;
			break;
		// wv
		case IDM_HELP:
			ShellExecute(hParent, _T("open"), _T(HELPFILE), NULL, NULL, SW_RESTORE);
			break;
		// o[W\
		case IDM_VERSION:
			createHelp(hParent, processHelp);
			break;
		// TCg
		case IDM_PAHOO:
			ShellExecute(NULL, _T("open"), _T(REFERENCE), NULL, NULL, SW_RESTORE);
			break;
		// Rs[
		case IDC_BUTTON_COPY:
		case IDM_COPY:
			setClipboardData(getStrEditBox(hParent, IDC_EDIT_GUID));
			break;
		// vOI
		case IDM_QUIT:
			// IvVۑ
			option = getOption(hDlg);
			saveParameter(option);
			EndDialog(hParent, 0);
			return FALSE;
		default:
			break;
	}
	break;

	// Spin Control
	case WM_NOTIFY:
		if (wParam == (WPARAM)IDC_SPIN_NUM) {
			lpnmud = (LPNMUPDOWN)lParam;
			if (lpnmud->hdr.code == UDN_DELTAPOS) {
				GuidNum = getIntEditBox(hDlg, IDC_EDIT_NUM);
				if ((lpnmud->iDelta) < 0) {
					GuidNum++;
				} else if ((lpnmud->iDelta) > 0) {
					GuidNum--;
				}
				if (GuidNum < MIN_GUID) {
					GuidNum = MIN_GUID;
				}
				if (GuidNum > MAX_GUID) {
					GuidNum = MAX_GUID;
				}
				setIntEditBox(hDlg, IDC_EDIT_NUM, GuidNum);
			}
		}
		break;

	// vOI
	case WM_CLOSE:
		// IvVۑ
		option = getOption(hDlg);
		saveParameter(option);
		EndDialog(hParent, 0);
		return FALSE;
	}
	return FALSE;
}

// GUICvO ======================================================
/**
 * WindowsCvO
 * @param	HINSTANCE hInstance			CX^Xnh
 * @paramm	HINSTANCE hPrevInstance		gp(NULL)FWin16̖c
 * @param	LPSTR lpCmdLine				R}hC
 * @paramL	int nShowCmd				EBhE̕\@
 * @return	int ^[R[h
*/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd) {
	LoadLibrary("RICHED20.DLL");
	hInst = hInstance;
	DialogBox(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)processMain);

	return 0;
}

#else
// CUICvO ======================================================
/**
 * CUIpCvO
 * @param	int argc
 * @paramm	char* argv[]
 * @return	int ^[R[h
 */
int main(int argc, char* argv[]) {
	int fmt = 0;
	string guids = "";

	// R}hCEIvV̒`
	options_description options("R}hCEIvV");
	options.add_options()
		("num,n", value<unsigned>(), "")
		("brace,b", "{...} ǉ")
		("trim,t", "nCt폜")
		("dest,d", value<std::string>(), "eLXgt@C֏o")
		("paste,p", "Nbv{[h֏o")
		("help,h", "wv")
		("version,v", "o[W")
		;
	// R}hCEIvV̎擾
	variables_map vm;
	try {
		store(parse_command_line(argc, argv, options), vm);
	} catch(const boost::program_options::error_with_option_name& e) {
		ErrorMessage =  e.what();
		cerr << ErrorMessage << endl;
		return 1;
	}
	notify(vm);

	// wv
	if (vm.count("help")) {
		cout << Help;
	// o[W
	} else if (vm.count("version")) {
		cout << Version;

	// GUID
	} else {
		// IvV߁GUID
		if (vm.count("brace")) {
			if (vm.count("trim")) {
				fmt = 3;
			} else {
				fmt = 2;
			}
		} else {
			if (vm.count("trim")) {
				fmt = 1;
			} else {
				fmt = 0;
			}
		}
		// 
		if (vm.count("num")) {
			GuidNum = (unsigned)vm["num"].as<unsigned>();
		} else {
			GuidNum = MIN_GUID;
		}
		// GUID
		if ((GuidNum >= MIN_GUID) && (GuidNum <= MAX_GUID)) {
			for (unsigned i = 0; i < GuidNum; i++) {
				Guid[i] = newGUID(fmt);
				guids = guids + Guid[i] + "\n";
			}
		} else {
			ErrorMessage = " " + to_string(MIN_GUID) + "ȏC" + to_string(MAX_GUID) + "ȉ̐w肵Ă";
			cerr << ErrorMessage << endl;
			return 1;
		}

		// eLXgt@C֏o
		if (vm.count("dest")) {
			auto outfile = vm["dest"].as<string>();
			ofstream ofs(outfile.c_str());
			ofs << guids;
			if (ofs.bad()) {
				ErrorMessage = outfile + " ւ݂̏Ɏs܂";
				cerr << ErrorMessage << endl;
				return 1;
			}
			ofs.close();
		// Nbv{[h֏o
		} else if (vm.count("paste")) {
			setClipboardData(guids);
		// Wo͂֏o
		} else {
			cout << guids;
		}
	}

	return 0;
}

#endif

/*
** o[WAbv =====================================================
 *
 * @version 1.4.9  2026/02/14 gpCuXV, optionalOՓˉ
 * @version 1.4.8  2025/10/18 gpCuXV
 * @version 1.4.7  2025/07/05 gpCuXV
 * @version 1.4.6  2025/03/08 gpCuXV
 * @version 1.4.5  2024/11/23 gpCuXV
 * @version 1.4.4  2024/07/27 gpCuXV
 * @version 1.4.3  2024/03/09 gpCuXV
 * @version 1.4.2  2023/11/04 gpCuXV
 * @version 1.4.1  2023/06/18 gpCuXV
 * @version 1.4.0  2023/03/11 ݒNA@\ǉCgpCuXV
 * @version 1.3    2022/07/16 DLLsvɁiÓINɕύXj
 * @version 1.2    2022/07/12 CUIłǉCCuXV
 * @version 1.1    2022/07/11 C`FbN̏ԁCEBhEʒuۑ
 * @version 1.0    2020/09/04 
*/
